import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Button, Popover, PopoverBody, PopoverHeader} from "reactstrap";

export default class DeleteButton extends Component {

    constructor(props) {
        super(props);
        this.state = {
            isOpen: false
        };
        this.toggle = this.toggle.bind(this);
    }

    toggle() {
        this.setState({isOpen: !this.state.isOpen});
    }

    render() {
        return(
            <Button id={this.props.id} onClick={this.toggle} size={this.props.size}
                className="btn-danger ionicon-btn">

                {!this.props.children && "Elimina"}
                {this.props.children}

                <Popover target={this.props.id} isOpen={this.state.isOpen} toggle={this.toggle}>
                    <PopoverHeader>Delete</PopoverHeader>
                    <PopoverBody>
                        Attenzione! Questa operazione non è reversibile, sei sicuro di voler procedere con l'eliminazione?<br />
                        <a className="btn btn-danger" onClick={() => {this.props.onDelete(); this.toggle() }}>Elimina</a>
                        <a className="btn" onClick={this.toggle}>Annulla</a>
                    </PopoverBody>
                </Popover>
            </Button>);
    }
}

DeleteButton.propTypes = {
    onDelete: PropTypes.func.isRequired,
};
